@extends('layouts.app')
@push('style')
    <style>
        .product-box {
            border: 1px solid #ddd;
            padding: 20px;
            margin: 10px 0;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            background-color: #f9f9f9;
            transition: all 0.3s ease-in-out;
        }

        .product-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.3);
        }

        .product-box .title {
            font-size: 1.2em;
            font-weight: bold;
            color: #fff;
            background-color: #28a745; /* Changed color */
            padding: 15px 20px;
            border-radius: 8px;
            margin-bottom: 10px;
            text-align: center;
            text-transform: uppercase;
            letter-spacing: 1px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
            transition: all 0.3s ease-in-out;
        }

        .product-box .title:hover {
            background-color: #218838; /* Changed color */
        }

        .product-box p {
            font-size: 1em;
            color: #333;
        }

        .btn_sell a {
            width: 100%;
            padding: 10px;
            font-size: 1em;
            font-weight: bold;
            color: #fff;
            background-color: #007bff; /* Changed color */
            border: none;
            border-radius: 5px;
            text-align: center;
            text-transform: uppercase;
            transition: background-color 0.3s ease-in-out;
        }

        .btn_sell a:hover {
            background-color: #0056b3; /* Changed color */
        }

        /* Photo upload styling */
        .custom-file-label::after {
            content: "Browse";
        }
        
        #photo_preview {
            text-align: center;
        }
        
        #preview_image {
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
    </style>
@endpush
@section('main')
    {{-- {{ $brands }} --}}
    <!-- Content Header (Page header) -->
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0 text-dark">POINT OF SALE</h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Dashboard v2</li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <div class="modal fade" id="show_profit_modal" tabindex="-1" role="dialog" aria-labelledby="show_profit_modal_label"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="show_profit_modal_label">আজকের প্রফিট রিপোর্ট</h4>
                </div>

                <div class="modal-body">
                    <div class="popup-content">
                        <!-- Dynamic profit data -->
                        <h3>মোট প্রফিট: <span id="profitValue">0.00 ৳</span></h3>
                        <p id="profitDetails">তারিখ: <span id="date"></span></p>

                        <!-- Close Button -->
                        <button type="button" class="btn btn-block btn-outline-danger btn-sm"
                            id="close_modal_btn">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- Main content -->
    <section class="content">
        <div class="row">


            <!-- fix for small devices only -->
            <div class="clearfix hidden-md-up"></div>

            <div class="col-12 col-sm-6 col-md-3">
                <div class="info-box mb-3">
                    <span class="info-box-icon bg-success elevation-1">
                        <i class="fas fa-hand-holding-usd"></i> <!-- Direct sale icon -->
                    </span>

                    <div class="info-box-content">
                        <a href="{{ route('direct-sales.create') }}" class="btn btn-primary">Direct Sale</a>
                    </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <!-- /.col -->

            <div class="col-12 col-sm-6 col-md-3">
                <div class="info-box mb-3">
                    <span class="info-box-icon bg-info elevation-1">
                        <i class="fas fa-user-plus"></i> <!-- Add customer icon -->
                    </span>

                    <div class="info-box-content">
                        <button type="button" class="btn btn-info" data-toggle="modal" data-target="#modal-add-customer">
                            <i class="fas fa-user-plus"></i> Add Customer
                        </button>
                    </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <!-- /.col -->


            <div class="col-12 col-sm-6 col-md-3">
                <div class="info-box mb-3">
                    <span class="info-box-icon bg-warning elevation-1">
                        <i class="fas fa-money-bill-wave"></i> <!-- Money bill icon for profit -->
                    </span>

                    <div class="info-box-content">
                        <button type="button" onclick="fetchProfit()" class="btn btn-info" id="openProfitModal">
                            <i class="fas fa-money-bill-wave"></i> Total Profit
                        </button>
                    </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <!-- /.col -->
        </div>


        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">

                        <div class="search-container">
                            <form class="search-form">
                                <div class="row">
                                    <div class="col-4">
                                        <div>
                                            <label for="search_type">Search by:</label>
                                            <select id="search_type" name="search_type" class="form-control">
                                                <option value="all">All</option>
                                                <option value="model">Model</option>
                                                <option value="brand">Brand</option>
                                                <option value="imei">IMEI/SN</option>
                                                <option value="name">Accessories/Others</option>
                                            </select>
                                        </div>


                                    </div>
                                    <div class="col-4">

                                        <label for="search_value">Search Value:</label>
                                        <input type="text" id="search_value" class="form-control" name="search_value"
                                            placeholder="Type to search...">

                                    </div>
                                </div>
                            </form>
                        </div>

                        <div id="search_results">
                            <h2>Product List</h2>
                            <div id="product_grid" class="product-container row text-center">
                                <!-- Products will be loaded here -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </section>

    {{-- Add Customer Modal --}}
    <div class="modal fade" id="modal-add-customer" tabindex="-1" role="dialog" aria-labelledby="modal-add-customer-label" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header bg-info text-white">
                    <h5 class="modal-title" id="modal-add-customer-label">
                        <i class="fas fa-user-plus mr-2"></i>Add New Customer
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="customer_form">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_name">
                                        <i class="fas fa-user mr-1"></i>Customer Name <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" id="customer_name" class="form-control" name="customer_name" placeholder="Enter customer name" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_number">
                                        <i class="fas fa-phone mr-1"></i>Phone Number <span class="text-danger">*</span>
                                    </label>
                                    <input type="tel" id="customer_number" class="form-control" name="customer_number" placeholder="Enter phone number" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_email">
                                        <i class="fas fa-envelope mr-1"></i>Email Address
                                    </label>
                                    <input type="email" id="customer_email" class="form-control" name="customer_email" placeholder="Enter email address">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_cpr">
                                        <i class="fas fa-id-card mr-1"></i>CPR/ID Number
                                    </label>
                                    <input type="text" id="customer_cpr" class="form-control" name="customer_cpr" placeholder="Enter CPR/ID number">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="address">
                                <i class="fas fa-map-marker-alt mr-1"></i>Address
                            </label>
                            <textarea id="address" class="form-control" name="address" rows="2" placeholder="Enter full address"></textarea>
                        </div>

                        <div class="form-group">
                            <label for="customer_notes">
                                <i class="fas fa-sticky-note mr-1"></i>Notes
                            </label>
                            <textarea id="customer_notes" class="form-control" name="customer_notes" rows="2" placeholder="Any additional notes about the customer"></textarea>
                        </div>

                        <div class="form-group">
                            <label for="cpr_photo">
                                <i class="fas fa-camera mr-1"></i>CPR/ID Photo
                            </label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="cpr_photo" name="cpr_photo" accept="image/*">
                                <label class="custom-file-label" for="cpr_photo">Choose photo...</label>
                            </div>
                            <small class="form-text text-muted">Supported formats: JPG, PNG, GIF (Max: 2MB)</small>
                            <div id="photo_preview" style="display: none; margin-top: 10px;">
                                <img id="preview_image" src="" alt="Photo Preview" style="max-width: 200px; max-height: 150px; border: 1px solid #ddd; border-radius: 5px;">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">
                            <i class="fas fa-times mr-1"></i>Cancel
                        </button>
                        <button type="submit" class="btn btn-info">
                            <i class="fas fa-save mr-1"></i>Save Customer
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        $(document).ready(function() {
            function fetchProducts() {
                let searchType = $('#search_type').val();
                let searchValue = $('#search_value').val();

                $.ajax({
                    url: "{{ route('products.fetch') }}",
                    method: "GET",
                    data: {
                        search_type: searchType,
                        search_value: searchValue
                    },
                    success: function(response) {
                        let productGrid = $('#product_grid');
                        productGrid.html('');
                        console.log("nasik", response);

                        if (response.length > 0) {
                            response.forEach(product => {
                                let brandName = product.product_brand ? product.product_brand
                                    .name : product.name;
                                let modelName = product.product_model ? product.product_model
                                    .name : product.type;
                                let conditionColor = product.condition === 'new' ? 'red' :
                                    'green';

                                let buyPrice = Number(product.buy_price || 0) +
                                    {{ $all_settings->pos_price_value }};
                                let buyPriceFormatted = buyPrice.toFixed(2);

                                let productHtml = `
                                                <div class="col-md-3">
                                                    <div class="product-box">
                                                        <div class="">
                                                            <div type="button" style="padding:0.2px" class="bg-gradient-success rounded title">
                                                                <h3 class="">
                                                                    <span class="brand"> ${brandName}</span><br>
                                                                </h3>
                                                                <p class="">
                                                                    <span class="model"><b>${modelName}</b></span>
                                                                </p>
                                                            </div>
                                                            <div class="mt-2">
                                                                <p>${product.gb || '-'} - ${product.color || '-'}</p>
                                                                <p><b>IMEI/SN:</b> ${product.imei_or_sn || '-'}</p>
                                                                <p><b>Condition:</b> <span style="color:${conditionColor};">${product.condition || '-'}</span></p>
                                                                <p><b>Buy Price:</b> {{ $all_settings->currency }} ${buyPriceFormatted}</p>
                                                                <p><b>Stock:</b> ${product.stock || '0'}</p>
                                                            </div>
                                                            <div class="btn_sell d-flex justify-content-center">
                                                                <a href="sell/${product.id}" class="btn btn-block bg-gradient-primary btn-sm" style="width:30%">Sell</a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            `;

                                productGrid.append(productHtml);
                            });
                        } else {
                            productGrid.html(
                                '<p style="text-align:center; color:red;">No products found.</p>');
                        }
                    }

                });
            }

            // Function to enable/disable input field based on selection
            function toggleSearchInput() {
                let searchType = $('#search_type').val();
                if (searchType === 'all') {
                    $('#search_value').val('').prop('disabled', true); // Clear and disable input
                } else {
                    $('#search_value').prop('disabled', false); // Enable input
                }
            }

            // Load all products initially
            fetchProducts();

            // Fetch products when typing in the search field
            $('#search_value').on('keyup', function() {
                fetchProducts();
            });

            // Fetch products when selecting a search type and toggle input field
            $('#search_type').on('change', function() {
                toggleSearchInput();
                fetchProducts();
            });

            // Initialize input state on page load
            toggleSearchInput();
        });



        // Function: Fetch today's profit
        function fetchProfit() {
            $.ajax({
                url: "{{ route('pos.fetch.profit') }}", // The route URL
                type: 'POST',
                dataType: 'json',
                data: {
                    action: 'fetchProfit',
                    _token: '{{ csrf_token() }}' // CSRF token
                },
                success: function(response) {
                    console.log("Profit data fetched successfully");

                    // Show modal
                    $('#show_profit_modal').modal('show');

                    // You can now handle the profit data here and update modal content accordingly
                    if (response.success) {
                        // Update the modal content with the profit data (example)
                        $('#show_profit_modal .modal-title').text('Today\'s Profit: ' + response.total_profit +
                            ' ৳');
                        // You can use more modal body elements here to display specific data if needed
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Error: " + error);
                }
            });
        }

        // Handle the close button click
        $('#close_modal_btn').click(function() {
            $('#show_profit_modal').modal('hide');
        });

        // Handle customer form submission
        $('#customer_form').on('submit', function(e) {
            e.preventDefault();
            
            // Create FormData object to handle file upload
            let formData = new FormData();
            formData.append('name', $('#customer_name').val());
            formData.append('number', $('#customer_number').val());
            formData.append('email', $('#customer_email').val());
            formData.append('cpr', $('#customer_cpr').val());
            formData.append('address', $('#address').val());
            formData.append('notes', $('#customer_notes').val());
            formData.append('_token', '{{ csrf_token() }}');
            
            // Add photo if selected
            let photoFile = $('#cpr_photo')[0].files[0];
            if (photoFile) {
                formData.append('cpr_photo', photoFile);
            }            // Disable submit button and show loading
            let submitBtn = $('#customer_form button[type="submit"]');
            let originalText = submitBtn.html();
            submitBtn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin mr-1"></i>Saving...');

            // Submit form via AJAX
            $.ajax({
                url: "{{ route('customer.store') }}",
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    if (response.success || response.customer) {
                        // Show success message with photo status
                        let message = 'Customer added successfully!';
                        if (response.photo_saved) {
                            message += ' Photo uploaded successfully.';
                        } else if ($('#cpr_photo')[0].files[0]) {
                            message += ' Note: Photo upload failed, but customer was saved.';
                        }
                        alert(message);
                        
                        // Reset form and preview
                        $('#customer_form')[0].reset();
                        $('#photo_preview').hide();
                        $('.custom-file-label').text('Choose photo...');
                        
                        // Close modal
                        $('#modal-add-customer').modal('hide');
                        
                        // You can add code here to refresh customer list if needed
                    } else {
                        alert('Error: ' + (response.message || 'Failed to add customer'));
                    }
                },
                error: function(xhr, status, error) {
                    let errorMessage = 'Failed to add customer';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    } else if (xhr.responseJSON && xhr.responseJSON.errors) {
                        let errors = xhr.responseJSON.errors;
                        errorMessage = Object.values(errors).flat().join('\n');
                    }
                    alert('Error: ' + errorMessage);
                },
                complete: function() {
                    // Re-enable submit button
                    submitBtn.prop('disabled', false).html(originalText);
                }
            });
        });

        // Handle photo file input change
        $('#cpr_photo').on('change', function() {
            const file = this.files[0];
            const label = $(this).next('.custom-file-label');
            
            if (file) {
                // Validate file size (2MB = 2 * 1024 * 1024 bytes)
                if (file.size > 2 * 1024 * 1024) {
                    alert('File size must be less than 2MB. Please choose a smaller file.');
                    $(this).val('');
                    label.text('Choose photo...');
                    $('#photo_preview').hide();
                    return;
                }
                
                // Validate file type
                if (!file.type.startsWith('image/')) {
                    alert('Please select a valid image file (JPG, PNG, GIF).');
                    $(this).val('');
                    label.text('Choose photo...');
                    $('#photo_preview').hide();
                    return;
                }
                
                // Update label with filename
                label.text(file.name);
                
                // Show preview
                const reader = new FileReader();
                reader.onload = function(e) {
                    $('#preview_image').attr('src', e.target.result);
                    $('#photo_preview').show();
                };
                reader.readAsDataURL(file);
            } else {
                label.text('Choose photo...');
                $('#photo_preview').hide();
            }
        });
    </script>
@endpush
